<?php

// ############################### start display options ###############################
if ($_REQUEST['action'] == 'entries')
{
	if (!LIVEWALL::$permissions['canview'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noperms',
		));
		die();	
	}
	
	$vbulletin->input->clean_array_gpc('r', array(
		'lastids' 	=> TYPE_ARRAY_UINT,
		'allids' 	=> TYPE_ARRAY,
		'userid' 	=> TYPE_UINT,
		'sidebar' 	=> TYPE_BOOL,
	));
	
	if (!LIVEWALL::$permissions['canviewuserwall'])
	{
		// Always null this out
		$vbulletin->GPC['userid'] = 0;
	}	
	if ($vbulletin->GPC['userid'])
	{
		$userinfo = ($vbulletin->GPC['userid'] == $vbulletin->userinfo['userid'] ? $vbulletin->userinfo : fetch_userinfo($vbulletin->GPC['userid']));
		if (!$userinfo)
		{
			// Not valid user
			$vbulletin->GPC['userid'] = 0;
		}
	}
	
	if (!function_exists('fetch_avatar_url'))
	{
		// Get the avatar function
		require_once(DIR . '/includes/functions_user.php');
	}
	
	// Store the entries
	$entries = array();
	
	// Fetch the data
	$data = LIVEWALL::fetchContentTypeData($vbulletin->GPC['lastids'], $vbulletin->GPC['userid'], -1, $vbulletin->GPC['allids'], $vbulletin->GPC['sidebar']);
	
	// Parse the BBCode that we generated
	require_once(DIR . '/includes/class_bbcode.php');	
	$parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());
	
	$comments = array();	
	foreach ($data as $info)
	{
		// Shorthand
		$contenttype = LIVEWALL::$cache['contenttype'][$info['contenttypeid']];
		
		// Init the object
		$contentTypeObj = LIVEWALL::initContentType($contenttype);
		
		// Do some array modifications
		$info['phrase'] = $contentTypeObj->constructPhrase($info);
		$info['actiondate'] = vbdate($vbulletin->options['dateformat'], $info['dateline'], true);
		$info['actiontime'] = vbdate($vbulletin->options['timeformat'], $info['dateline']);
		$info['display'] = 'none';
		if ($vbulletin->options['dbtech_livewall_inlinecomments'])
		{
			$info['commentcount'] = count(LIVEWALL::$allComments[$info['contenttypeid']][$info['contentid']]);
		}
		
		if ($vbulletin->options['dbtech_livewall_enable_previews'] AND $contenttype['preview' . ($vbulletin->GPC['sidebar'] ? '_sidebar' : '')])
		{
			// We're doing some form of preview trimming
			$info['preview'] = $parser->parse(fetch_trimmed_title($info['pagetext'], $contenttype['preview' . ($vbulletin->GPC['sidebar'] ? '_sidebar' : '')]), 'nonforum');
		}
		
		// Install avatar info
		fetch_avatar_from_userinfo($info);
		
		foreach ((array)LIVEWALL::$allComments[$info['contenttypeid']][$info['contentid']] as $info2)
		{
			// Install avatar info
			fetch_avatar_from_userinfo($info2);
			
			$info2['actiondate'] 	= vbdate($vbulletin->options['dateformat'], $info2['dateline'], true);
			$info2['actiontime'] 	= vbdate($vbulletin->options['timeformat'], $info2['dateline']);
			$info2['message'] 		= $parser->parse($info2['message'], 'nonforum');
			
			// Whether we can delete comments
			$show['deletecomment'] = ($info2['userid'] == $vbulletin->userinfo['userid'] ?
				LIVEWALL::$permissions['candeletecomments'] :
				LIVEWALL::$permissions['candeleteotherscomments']
			);			
			
			$templater = vB_Template::create('dbtech_livewall_comment_inline');
				$templater->register('entry', 	$info2);
			$info['comments'] .= $templater->render();
			
			// We've already done these
			unset(LIVEWALL::$allComments[$info['contenttypeid']][$info['contentid']]);
		}		
		
		$templaterr = vB_Template::create('dbtech_livewall_' . ($vbulletin->GPC['sidebar'] ? 'block_' : '') . 'entry');
			$templaterr->register('entry', 	$info);
		$entries[] = $templaterr->render();
	}
	
	foreach ((array)LIVEWALL::$allComments as $contenttypeid => $arr)
	{
		foreach ($arr as $contentid => $arr2)
		{
			foreach ($arr2 as $commentid => $info2)
			{
				// Install avatar info
				fetch_avatar_from_userinfo($info2);
				
				$info2['actiondate'] 	= vbdate($vbulletin->options['dateformat'], $info2['dateline'], true);
				$info2['actiontime'] 	= vbdate($vbulletin->options['timeformat'], $info2['dateline']);
				$info2['message'] 		= $parser->parse($info2['message'], 'nonforum');
				
				// Whether we can delete comments
				$show['deletecomment'] = ($info2['userid'] == $vbulletin->userinfo['userid'] ?
					LIVEWALL::$permissions['candeletecomments'] :
					LIVEWALL::$permissions['candeleteotherscomments']
				);
				
				$templater = vB_Template::create('dbtech_livewall_comment_inline');
					$templater->register('entry', 	$info2);
				$comments[$contenttypeid][$contentid][] = $templater->render();
			}
		}
	}		
	unset($parser);
	
	echo LIVEWALL::encodeJSON(array(
		'lastids' 	=> LIVEWALL::$lastIds,
		
		'entries' 	=> $entries
	));
	die();	
}



// ############################### start display options ###############################
if ($_POST['action'] == 'savestatus')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'message' 	=> TYPE_STR,
	));
	
	if (!LIVEWALL::$permissions['canview'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'noperms',
		));
		die();	
	}
	
	if (!$vbulletin->options['dbtech_livewall_status_maxlength'])
	{
		// Always null this out
		echo LIVEWALL::encodeJSON(array(
			'error' => 'statusoff',
		));
		die();	
	}	
	
	if ((TIMENOW - $vbulletin->options['dbtech_livewall_status_delay']) < LIVEWALL::$db->fetchOne('SELECT dateline FROM $dbtech_livewall_status WHERE userid = ?', array($vbulletin->userinfo['userid'])))
	{
		// Just add a dummy error, this shouldn't really happen
		echo LIVEWALL::encodeJSON(array(
			'error' => 'toosoon',
		));
		die();
	}
	
	LIVEWALL::$db->insert('dbtech_livewall_status', array(
		'userid' 	=> $vbulletin->userinfo['userid'],
		'pagetext' 	=> str_replace(array("\n"), '', trim(convert_urlencoded_unicode(urldecode($vbulletin->GPC['message'])))),
		'dateline' 	=> TIMENOW
	));
	
	echo LIVEWALL::encodeJSON(array(
		'dorefresh' => true,
	));
	die();	
}


?>